<?php
/**
 * Single product short description
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/short-description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $post;

$short_description = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
$short_description_title = apply_filters( 'woocommerce_short_description_title', $post->post_title );

if ( ! $short_description ) {
	return;
}

?>
<div class="woocommerce-product-details__short-description">
	<b><?php echo $short_description_title; // WPCS: XSS ok. ?></b><br/>
	<?php echo $short_description; // WPCS: XSS ok. ?>
	<u><a href="#tab-description">> En savoir plus</a></u>

<!--FICHE TECHNIQUE-->
<?php $fiche_technique = esc_attr( get_field('fiche_technique'));
if(empty($fiche_technique)){echo ' ';
}else{?>

<a href="<?php echo esc_attr( get_field('fiche_technique') ); ?>" style="float:right;padding:8px 10px; margin:10px;background:#2F3663;color:#f7cd43;" target="_blank"> &#8801; TELECHARGER LA FICHE TECHNIQUE</a>
<?php ;}
?>
<!--FIN FICHE TECHNIQUE-->



</div>








