<?php
defined( 'ABSPATH' ) or die();

add_filter( 'rsssl_fields', function( $fields ) {
	return array_merge( $fields,
		[

			[
				'id'                 => 'disable_anyone_can_register',
				'menu_id'            => 'hardening-basic',
				'group_id'           => 'hardening-basic',
				'type'               => 'checkbox',
				'label'              => __( "Disable \"anyone can register\"", 'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => false,
				'help'               => [
					'label' => 'default',
					'url'   => 'definition/what-are-hardening-features',
					'title' => __( "About Hardening", 'really-simple-ssl' ),
					'text'  => __( 'Hardening features limit the possibility of potential weaknesses and vulnerabilities which can be misused.', 'really-simple-ssl' ),
				],
				'recommended'        => true,
			],
			[
				'id'                 => 'disable_file_editing',
				'menu_id'            => 'hardening-basic',
				'group_id'           => 'hardening-basic',
				'type'               => 'checkbox',
				'label'              => __( "Disable the built-in file editors", 'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => false,
				'recommended'        => true,
			],
			[
				'id'                 => 'block_code_execution_uploads',
				'menu_id'            => 'hardening-basic',
				'group_id'           => 'hardening-basic',
				'type'               => 'checkbox',
				'label'              => __( "Prevent code execution in the public 'Uploads' folder", 'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => false,
				'recommended' => true,
			],
			[
				'id'       => 'hide_wordpress_version',
				'menu_id'  => 'hardening-basic',
				'group_id' => 'hardening-basic',
				'type'     => 'checkbox',
				'label'    => __( "Hide your WordPress version", 'really-simple-ssl' ),
				'disabled' => false,
				'default'  => false,
				'recommended' => true,
			],
			[
				'id'       => 'disable_login_feedback',
				'menu_id'  => 'hardening-basic',
				'group_id' => 'hardening-basic',
				'type'     => 'checkbox',
				'tooltip'  => __( "By default, WordPress shows if a username or email address exists when a login fails. This will change it to generic feedback.", 'really-simple-ssl' ),
				'label'    => __( "Prevent login feedback", 'really-simple-ssl' ),
				'disabled' => false,
				'default'  => false,
				'recommended' => true,
			],
			[
				'id'                 => 'disable_indexing',
				'menu_id'            => 'hardening-basic',
				'group_id'           => 'hardening-basic',
				'type'               => 'checkbox',
				'label'              => __( "Disable directory browsing", 'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => false,
				'recommended' => true,
			],
			[
				'id'                 => 'disable_user_enumeration',
				'menu_id'            => 'hardening-basic',
				'group_id'           => 'hardening-basic',
				'type'               => 'checkbox',
				'label'              => __( "Disable user enumeration", 'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => false,
				'recommended' => true,
			],
			[
				'id'                 => 'rename_admin_user',
				'menu_id'            => 'hardening-basic',
				'warning'     			=> true,
				'group_id'           => 'hardening-basic',
				'type'               => 'checkbox',
				'label'              => __( "Block the username 'admin'", 'really-simple-ssl' ),
				'email'              => [
					'title'   => __( "Settings update: Username 'admin' renamed", 'really-simple-ssl' ),
					'message' => sprintf(__( "As a security precaution, the username ‘admin’ has been changed on %s. From now on, you can login with '%s' or an email address.", 'really-simple-ssl' ), '{site_url}','{username}'),
					'url'     => 'instructions/locked-our-after-renaming-the-admin-username',
					'condition'    => 'rsssl_username_admin_changed',
				],
				'tooltip'            => __( "If the username 'admin' currently exists, you can rename it here. Please note that you can no longer use this username, and should use the new username or an email address",
					'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => false,
			],
			[
				'id'                 => 'new_admin_user_login',
				'menu_id'            => 'hardening-basic',
				'group_id'           => 'hardening-basic',
				'type'               => 'text',
				'label'              => __( "Choose new username to replace 'admin'", 'really-simple-ssl' ),
				'disabled'           => false,
				'default'            => '',
				'required'           => true,
				'condition_action'   => 'hide',
				'react_conditions' => [
					'relation' => 'AND',
					[
						'rename_admin_user' => 1,
					]
				],
				'server_conditions' => [
					'relation' => 'AND',
					[
						'rsssl_has_admin_user()' => true,
					]
				],

			],
			[
				'id'       => 'disable_xmlrpc',
				'menu_id'  => 'hardening-basic',
				'group_id' => 'hardening-basic',
				'type'     => 'checkbox',
				'label'    => __( "Disable XML-RPC", 'really-simple-ssl' ),
				'disabled' => false,
				'default'  => false,
			],
			[
				'id'       => 'block_display_is_login',
				'menu_id'  => 'hardening-basic',
				'group_id' => 'hardening-basic',
				'type'     => 'checkbox',
				'label'    => __( "Block user registrations when login and display name are the same", 'really-simple-ssl' ),
				'disabled' => false,
				'default'  => false,
			],
			[
				'id'       => 'disable_http_methods',
				'menu_id'  => 'hardening-extended',
				'group_id' => 'hardening-extended',
				'type'     => 'checkbox',
				'tooltip'  => __( "This will limit or fully disable HTTP requests that are not needed, but could be used with malicious intent.", 'really-simple-ssl' ),
				'label'    => __( "Disable HTTP methods", 'really-simple-ssl' ),
				'disabled' => false,
				'default'  => false,
			],
			[
				'id'       => 'rename_db_prefix',
				'menu_id'  => 'hardening-extended',
				'group_id' => 'hardening-extended',
				'email'            => [
					'title'   => __( "Settings update: Database prefix changed", 'really-simple-ssl' ),
					'message' => __( "Security through obscurity. Your site is no longer using the default wp_ prefix for database tables. The process has been designed to only complete and replace the tables after all wp_ tables are successfully renamed. In the unlikely event that this does lead to database issues on your site, please navigate to our troubleshooting article.", 'really-simple-ssl' ),
					'url'     => 'instructions/database-issues-after-changing-prefix',
				],
				'tooltip'  => __( "This will permanently change your database prefixes and you can NOT rollback this feature. Please make sure you have a back-up.", 'really-simple-ssl' ),
				'warning'  => __( "This will permanently change your database prefixes and you can NOT rollback this feature. Please make sure you have a back-up.", 'really-simple-ssl' ),
				'type'     => 'checkbox',
				'label'    => __( "Rename and randomize your database prefix", 'really-simple-ssl' ),
				'disabled' => false,
				'default'  => false,
			],
		]
	);
}, 200 );
