<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$premium['bbpress'] = array(
	'url'  => 'https://ultimatemember.com/extensions/bbpress/',
	'img'  => 'bbpress.svg',
	'name' => 'bbPress',
	'desc' => 'With the bbPress extension you can integrate Ultimate Member with bbPress',
);

$premium['profile-completeness'] = array(
	'url'  => 'https://ultimatemember.com/extensions/profile-completeness/',
	'img'  => 'profile-completeness.svg',
	'name' => 'Profile Completeness',
	'desc' => 'Encourage or force users to complete their profile on your site',
);

$premium['verified-users'] = array(
	'url'  => 'https://ultimatemember.com/extensions/verified-users/',
	'img'  => 'verified-users.svg',
	'name' => 'Verified Users',
	'desc' => 'Add a user verficiation system to your site so user accounts can be verified',
);

$premium['friends'] = array(
	'url'  => 'https://ultimatemember.com/extensions/friends/',
	'img'  => 'friends.svg',
	'name' => 'Friends',
	'desc' => 'Increase user interaction on your site by allowing users to become friends',
);

$premium['woocommerce'] = array(
	'url'  => 'https://ultimatemember.com/extensions/woocommerce/',
	'img'  => 'woocommerce.png',
	'name' => 'WooCommerce',
	'desc' => 'Integrates the popular e-commerce plugin WooCommerce with Ultimate Member',
);

$premium['notices'] = array(
	'url'  => 'https://ultimatemember.com/extensions/notices/',
	'img'  => 'notices.svg',
	'name' => 'Notices',
	'desc' => 'Alert users to important information using conditional notices',
);

$premium['followers'] = array(
	'url'  => 'https://ultimatemember.com/extensions/followers/',
	'img'  => 'followers.svg',
	'name' => 'Followers',
	'desc' => 'Increase user interaction on your site by allowing users to follow each other',
);

$premium['mycred'] = array(
	'url'  => 'https://ultimatemember.com/extensions/mycred/',
	'img'  => 'mycred.png',
	'name' => 'myCRED',
	'desc' => 'With the myCRED extension you can integrate Ultimate Member with myCRED',
);

$premium['private-messages'] = array(
	'url'  => 'https://ultimatemember.com/extensions/private-messages/',
	'img'  => 'private-messages.svg',
	'name' => 'Private Messages',
	'desc' => 'Add a private messaging system to your site & allow users to message each other',
);

$premium['social-activity'] = array(
	'url'  => 'https://ultimatemember.com/extensions/social-activity/',
	'img'  => 'social-activity.svg',
	'name' => 'Social Activity',
	'desc' => 'Let users create public wall posts & see the activity of other users',
);

$premium['social-login'] = array(
	'url'  => 'https://ultimatemember.com/extensions/social-login/',
	'img'  => 'social-login.svg',
	'name' => 'Social Login',
	'desc' => 'Let users register & login to your site via Facebook, X (formerly Twitter), G+, LinkedIn, and more',
);

$premium['user-tags'] = array(
	'url'  => 'https://ultimatemember.com/extensions/user-tags/',
	'img'  => 'user-tags.svg',
	'name' => 'User Tags',
	'desc' => 'With this extension you can add a user tag system to your website',
);


$premium['mailchimp'] = array(
	'url'  => 'https://ultimatemember.com/extensions/mailchimp/',
	'img'  => 'mailchimp.png',
	'name' => 'MailChimp',
	'desc' => 'Allow users to subscribe to your mailchimp lists when they signup on your site',
);


$premium['user-reviews'] = array(
	'url'  => 'https://ultimatemember.com/extensions/user-reviews/',
	'img'  => 'user-reviews.svg',
	'name' => 'User Reviews',
	'desc' => 'Allow users to rate & review each other using a 5 star rate/review system',
);

$premium['real-time-notifications'] = array(
	'url'  => 'https://ultimatemember.com/extensions/real-time-notifications/',
	'img'  => 'real-time-notifications.svg',
	'name' => 'Real-time Notifications',
	'desc' => 'Add a notifications system to your site so users can receive real-time notifications',
);

$premium['private-content'] = array(
	'url'  => 'https://ultimatemember.com/extensions/private-content/',
	'img'  => 'private-content.svg',
	'name' => 'Private Content',
	'desc' => 'Display private content to logged in users that only they can access',
);

$premium['groups'] = array(
	'url'  => 'https://ultimatemember.com/extensions/groups/',
	'img'  => 'groups.svg',
	'name' => 'Groups',
	'desc' => 'Allow users to create and join groups around shared topics, interests etc.',
);

$premium['user-photos'] = array(
	'url'  => 'https://ultimatemember.com/extensions/user-photos/',
	'name' => 'User Photos',
	'img'  => 'user-photos.svg',
	'desc' => 'Allow users to upload photos to their profile',
);

$premium['user-bookmarks'] = array(
	'url'  => 'https://ultimatemember.com/extensions/user-bookmarks/',
	'img'  => 'user-bookmarks.svg',
	'name' => 'User Bookmarks',
	'desc' => 'Allow users to bookmark content from your website',
);

$premium['unsplash'] = array(
	'url'  => 'https://ultimatemember.com/extensions/unsplash/',
	'img'  => 'unsplash.png',
	'name' => 'Unsplash',
	'desc' => 'Allow users to select a profile cover photo from <a href="https://unsplash.com/" target="_blank">Unsplash</a> from their profile',
);

$premium['user-locations'] = array(
	'url'  => 'https://ultimatemember.com/extensions/user-locations/',
	'img'  => 'user-locations.svg',
	'name' => 'User Locations',
	'desc' => 'Using the Google Maps API, display users on a map on the member directory page and allow users to add their location via their profile',
);

$premium['user-notes'] = array(
	'url'  => 'https://ultimatemember.com/extensions/user-notes/',
	'img'  => 'user-notes.svg',
	'name' => 'User Notes',
	'desc' => 'Allow users to create public and private notes from their profile',
);

$premium['profile-tabs'] = array(
	'url'  => 'https://ultimatemember.com/extensions/profile-tabs/',
	'img'  => 'profile-tabs.svg',
	'name' => 'Profile Tabs',
	'desc' => 'Add custom tabs to profiles',
);

$premium['stripe'] = array(
	'url' => 'https://ultimatemember.com/extensions/stripe/',
	'img'  => 'stripe.png',
	'name' => 'Stripe',
	'desc' => 'Sell paid memberships to access your website via Stripe subscriptions',
);

//$premium['zapier'] = array(
//	'url' => 'https://ultimatemember.com/extensions/zapier/',
//	'img'  => 'zapier.png',
//	'name' => 'Zapier',
//	'desc' => 'Integrates your Zapier with Ultimate Member',
//);

$free['jobboardwp'] = array(
	'url'  => 'https://wordpress.org/plugins/um-jobboardwp',
	'img'  => 'jobboardwp.png',
	'name' => 'JobBoardWP',
	'desc' => 'Integrates Ultimate Member with the job board plugin <a href="https://wordpress.org/plugins/jobboardwp" target="_blank">JobBoardWP</a>',
);

$free['forumwp'] = array(
	'url'  => 'https://ultimatemember.com/extensions/forumwp/',
	'img'  => 'forumwp.png',
	'name' => 'ForumWP',
	'desc' => 'Integrates Ultimate Member with the forum plugin <a href="https://forumwpplugin.com" target="_blank">ForumWP</a>',
);

$free['online-users'] = array(
	'url'  => 'https://ultimatemember.com/extensions/online-users/',
	'img'  => 'online-users.svg',
	'name' => 'Online Users',
	'desc' => 'Display online users on your site so users can see who is online',
);

$free['google-recaptcha'] = array(
	'url'  => 'https://ultimatemember.com/extensions/google-recaptcha/',
	'img'  => 'google-recaptcha.png',
	'name' => 'Google reCAPTCHA',
	'desc' => 'Stop bots on your registration & login forms with Google reCAPTCHA',
);

$free['terms-conditions'] = array(
	'url'  => 'https://ultimatemember.com/extensions/terms-conditions/',
	'img'  => 'terms-conditions.svg',
	'name' => 'Terms & Conditions',
	'desc' => 'Add terms & conditions to your registration form',
);

$classes = array(
	'free'    => '',
	'premium' => '',
);
$loop    = $premium;
// phpcs:disable WordPress.Security.NonceVerification -- Don't need nonce for the filter.
if ( ! isset( $_REQUEST['filter'] ) || 'premium' === sanitize_key( $_REQUEST['filter'] ) ) {
	$loop               = $premium;
	$classes['premium'] = 'current';
} elseif ( 'free' === sanitize_key( $_REQUEST['filter'] ) ) {
	$loop            = $free;
	$classes['free'] = 'current';
}
// phpcs:enable WordPress.Security.NonceVerification -- Don't need nonce for the filter.
?>

<div id="um-extensions-wrap" class="wrap">

	<h2>Ultimate Member - Extensions</h2>

	<div class="wp-filter">
		<ul class="filter-links">
			<li>
				<a href="?page=ultimatemember-extensions&filter=premium" class="<?php echo esc_attr( $classes['premium'] ); ?>">
					<?php esc_html_e( 'Premium', 'ultimate-member' ); ?>
				</a>
			</li>
			<li>
				<a href="?page=ultimatemember-extensions&filter=free" class="<?php echo esc_attr( $classes['free'] ); ?>">
					<?php esc_html_e( 'Free', 'ultimate-member' ); ?>
				</a>
			</li>
		</ul>
	</div>

	<div class="wp-list-table widefat plugin-install">
		<div id="the-list">
			<?php foreach ( $loop as $key => $info ) { ?>
				<div class="plugin-card">
					<div class="plugin-image-wrapper">
						<?php
						$image_class = 'plugin-image';
						if ( false !== strpos( $info['img'], '.svg' ) ) {
							$image_class .= ' svg-image';
						}
						?>
						<a href="<?php echo esc_url( $info['url'] ); ?>" class="<?php echo esc_attr( $image_class ); ?>">
							<img id="<?php echo esc_attr( 'um_' . $key . '_image' ); ?>" src="<?php echo esc_url( UM_URL . 'assets/img/extensions/' . $info['img'] ); ?>" alt="<?php echo esc_attr( $info['name'] ); ?>" />
						</a>
					</div>
					<div class="plugin-card-top">
						<h3><a href="<?php echo esc_url( $info['url'] ); ?>"><?php echo esc_html( $info['name'] ); ?></a></h3>

						<div class="desc column-description">
							<?php echo wp_kses( $info['desc'], UM()->get_allowed_html( 'admin_notice' ) ); ?>
						</div>
					</div>
					<div class="plugin-action-links">
						<a class="button" href="<?php echo esc_url( $info['url'] ); ?>">
							<?php esc_html_e( 'Get this Add on', 'ultimate-member' ); ?>
						</a>
						<a href="<?php echo esc_url( $info['url'] ); ?>">
							<?php esc_html_e( 'More Details', 'ultimate-member' ); ?>
						</a>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<div class="clear"></div>
