// Generated by CoffeeScript 1.6.2
(function($) {
(function() {
  var iOSCheckbox, matched, userAgent,
    __slice = [].slice;

  if ($.browser == null) {
    userAgent = navigator.userAgent || "";
    jQuery.uaMatch = function(ua) {
      var match;

      ua = ua.toLowerCase();
      match = /(chrome)[ \/]([\w.]+)/.exec(ua) || /(webkit)[ \/]([\w.]+)/.exec(ua) || /(opera)(?:.*version)?[ \/]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+))?/.exec(ua) || [];
      return {
        browser: match[1] || "",
        version: match[2] || "0"
      };
    };
    matched = jQuery.uaMatch(userAgent);
    jQuery.browser = {};
    if (matched.browser) {
      jQuery.browser[matched.browser] = true;
      jQuery.browser.version = matched.version;
    }
    if (jQuery.browser.webkit) {
      jQuery.browser.safari = true;
    }
  }

  iOSCheckbox = (function() {
    function iOSCheckbox(elem, options) {
      var key, opts, value;

      this.elem = $(elem);
      opts = $.extend({}, iOSCheckbox.defaults, options);
      for (key in opts) {
        value = opts[key];
        this[key] = value;
      }
      this.elem.data(this.dataName, this);
      this.wrapCheckboxWithDivs();
      this.attachEvents();
      this.disableTextSelection();
      this.calculateDimensions();
    }

    iOSCheckbox.prototype.calculateDimensions = function() {
      if (this.resizeHandle) {
        this.optionallyResize('handle');
      }
      if (this.resizeContainer) {
        this.optionallyResize('container');
      }
      return this.initialPosition();
    };

    iOSCheckbox.prototype.isDisabled = function() {
		if ( this.elem.is(':disabled') )
			return true;
		else if ( this.elem.attr('checkbox-disabled') == 'true' )
			return true;
		else
			return false;
    };

    iOSCheckbox.prototype.wrapCheckboxWithDivs = function() {
      this.elem.wrap("<div class='" + this.containerClass + "' />");
      this.container = this.elem.parent();
      this.offLabel = $("<label class='" + this.labelOffClass + "'>\n  <span>" + this.uncheckedLabel + "</span>\n</label>").appendTo(this.container);
      this.offSpan = this.offLabel.children('span');
      this.onLabel = $("<label class='" + this.labelOnClass + "'>\n  <span>" + this.checkedLabel + "</span>\n</label>").appendTo(this.container);
      this.onSpan = this.onLabel.children('span');
      return this.handle = $("<div class='" + this.handleClass + "'>\n  <div class='" + this.handleRightClass + "'>\n    <div class='" + this.handleCenterClass + "' />\n  </div>\n</div>").appendTo(this.container).before("<span class='iPhoneCheckBeforeContainer'>&nbsp;</span><span class='iPhoneCheckAfterContainer'>&nbsp;</span>");
    };

    iOSCheckbox.prototype.disableTextSelection = function() {
      if ($.browser.msie) {
        return $([this.handle, this.offLabel, this.onLabel, this.container]).attr("unselectable", "on");
      }
    };

    iOSCheckbox.prototype._getDimension = function(elem, dimension) {
      if ($.fn.actual != null) {
        return elem.actual(dimension);
      } else {
        return elem[dimension]();
      }
    };

    iOSCheckbox.prototype.optionallyResize = function(mode) {
      var newWidth, offLabelWidth, offSpan, onLabelWidth, onSpan;

      onSpan = this.onLabel.find('span');
      onLabelWidth = this._getDimension(onSpan, "width");
      onLabelWidth += parseInt(onSpan.css('padding-right'), 10);
      offSpan = this.offLabel.find('span');
      offLabelWidth = this._getDimension(offSpan, "width");
      offLabelWidth += parseInt(offSpan.css('padding-left'), 10);
      if (mode === "container") {
        newWidth = onLabelWidth > offLabelWidth ? onLabelWidth : offLabelWidth;
        newWidth += this._getDimension(this.handle, "width") + this.handleMargin;
        return this.container.css({
          width: newWidth
        });
      } else {
        newWidth = onLabelWidth > offLabelWidth ? onLabelWidth : offLabelWidth;
        return this.handle.css({
          width: newWidth
        });
      }
    };

    iOSCheckbox.prototype.onMouseDown = function(event) {
      var x;

      event.preventDefault();
      if (this.isDisabled()) {
        return;
      }
      x = event.pageX || event.originalEvent.changedTouches[0].pageX;
      iOSCheckbox.currentlyClicking = this.handle;
      iOSCheckbox.dragStartPosition = x;
      return iOSCheckbox.handleLeftOffset = parseInt(this.handle.css('right'), 10) || 0;
    };

    iOSCheckbox.prototype.onDragMove = function(event, x) {
      var newWidth, p, leftHandle;

      if (iOSCheckbox.currentlyClicking !== this.handle) {
        return;
      }
      p = (x + iOSCheckbox.handleLeftOffset - iOSCheckbox.dragStartPosition) / this.rightSide;
      if (p < 0) {
        p = 0;
      }
      if (p > 1) {
        p = 1;
      }
      newWidth = p * this.rightSide;
	  leftHandle = newWidth;
	  if ( leftHandle == 0 ) leftHandle = -1;
      this.handle.css({
        right: leftHandle
      });
      this.onLabel.css({
        width: newWidth + this.handleRadius
      });
      this.offSpan.css({
        marginLeft: -newWidth
      });
      return this.onSpan.css({
        marginRight: -(1 - p) * this.rightSide
      });
    };

    iOSCheckbox.prototype.onDragEnd = function(event, x) {
      var p;

      if (iOSCheckbox.currentlyClicking !== this.handle) {
        return;
      }
      if (this.isDisabled()) {
        return;
      }
      if (iOSCheckbox.dragging) {
        p = (x - iOSCheckbox.dragStartPosition) / this.rightSide;
        this.elem.prop('checked', p >= 0.5);
      } else {
        this.elem.prop('checked', !this.elem.prop('checked'));
      }
      iOSCheckbox.currentlyClicking = null;
      iOSCheckbox.dragging = null;
      return this.didChange();
    };

    iOSCheckbox.prototype.refresh = function() {
      return this.didChange();
    };

    iOSCheckbox.prototype.didChange = function() {
      var new_left, leftHandle;

      if (typeof this.onChange === "function") {
        this.onChange(this.elem, this.elem.prop('checked'));
      }
      if (this.isDisabled()) {
        this.container.addClass(this.disabledClass);
        return false;
      } else {
        this.container.removeClass(this.disabledClass);
      }
      new_left = this.elem.prop('checked') ? this.rightSide : 0;
	  leftHandle = new_left;
	  if ( leftHandle == 0 ) leftHandle = -1;
      this.handle.animate({
        right: leftHandle
      }, this.duration);
      this.onLabel.animate({
        width: new_left + this.handleRadius
      }, this.duration);
      this.offSpan.animate({
        marginLeft: -new_left
      }, this.duration);
      this.onSpan.animate({
        marginRight: new_left - this.rightSide
      }, this.duration);
	  if (typeof this.onEnd === "function") {
        this.onEnd(this.elem, this.elem.prop('checked'));
      }
	  return true;
    };

    iOSCheckbox.prototype.attachEvents = function() {
      var localMouseMove, localMouseUp, self;

      self = this;
      localMouseMove = function(event) {
        return self.onGlobalMove.apply(self, arguments);
      };
      localMouseUp = function(event) {
        self.onGlobalUp.apply(self, arguments);
        $(document).unbind('mousemove touchmove', localMouseMove);
        return $(document).unbind('mouseup touchend', localMouseUp);
      };
      this.elem.change(function() {
        return self.refresh();
      });
      return this.container.bind('mousedown touchstart', function(event) {
        self.onMouseDown.apply(self, arguments);
        $(document).bind('mousemove touchmove', localMouseMove);
        return $(document).bind('mouseup touchend', localMouseUp);
      });
    };

    iOSCheckbox.prototype.initialPosition = function() {
      var containerWidth, offset, leftHandle;

      containerWidth = this._getDimension(this.container, "width");
      this.offLabel.css({
        width: containerWidth - this.containerRadius - 16
      });
      offset = this.containerRadius + 1;
      if ($.browser.msie && $.browser.version < 7) {
        offset -= 3;
      }
      this.rightSide = containerWidth - this._getDimension(this.handle, "width") - offset;
	  leftHandle = this.rightSide;
	  if ( leftHandle == 0 ) leftHandle = -1;
      if (this.elem.is(':checked')) {
        this.handle.css({
          right: leftHandle
        });
        this.onLabel.css({
          width: this.rightSide + this.handleRadius
        });
        this.offSpan.css({
          marginLeft: -this.rightSide
        });
      } else {
        this.onLabel.css({
          width: this.handleRadius
        });
        this.onSpan.css({
          marginRight: -this.rightSide
        });
      }
      if (this.isDisabled()) {
        return this.container.addClass(this.disabledClass);
      }
    };

    iOSCheckbox.prototype.onGlobalMove = function(event) {
      var x;

      if (!(!this.isDisabled() && iOSCheckbox.currentlyClicking)) {
        return;
      }
      event.preventDefault();
      x = event.pageX || event.originalEvent.changedTouches[0].pageX;
      if (!iOSCheckbox.dragging && (Math.abs(iOSCheckbox.dragStartPosition - x) > this.dragThreshold)) {
        iOSCheckbox.dragging = true;
      }
      return this.onDragMove(event, x);
    };

    iOSCheckbox.prototype.onGlobalUp = function(event) {
      var x;

      if (!iOSCheckbox.currentlyClicking) {
        return;
      }
      event.preventDefault();
      x = event.pageX || event.originalEvent.changedTouches[0].pageX;
      this.onDragEnd(event, x);
      return false;
    };

    iOSCheckbox.defaults = {
      duration: 200,
      checkedLabel: 'ON',
      uncheckedLabel: 'OFF',
      resizeHandle: true,
      resizeContainer: true,
      disabledClass: 'iPhoneCheckDisabled',
      containerClass: 'iPhoneCheckContainer',
      labelOnClass: 'iPhoneCheckLabelOn',
      labelOffClass: 'iPhoneCheckLabelOff',
      handleClass: 'iPhoneCheckHandle',
      handleCenterClass: 'iPhoneCheckHandleCenter',
      handleRightClass: 'iPhoneCheckHandleRight',
      dragThreshold: 5,
      handleMargin: 15,
      handleRadius: 4,
      containerRadius: 5,
      dataName: "iphoneStyle",
      onChange: function() {},
	  onEnd: function() {}
    };

    return iOSCheckbox;

  })();

  $.iphoneStyle = this.iOSCheckbox = iOSCheckbox;

  $.fn.iphoneStyle = function() {
    var args, checkbox, dataName, existingControl, method, params, _i, _len, _ref, _ref1, _ref2, _ref3, _refradio;

    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    dataName = (_ref = (_ref1 = args[0]) != null ? _ref1.dataName : void 0) != null ? _ref : iOSCheckbox.defaults.dataName;
    _ref2 = this.filter(':checkbox');
    for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
      checkbox = _ref2[_i];
      existingControl = $(checkbox).data(dataName);
      if (existingControl != null) {
        method = args[0], params = 2 <= args.length ? __slice.call(args, 1) : [];
        if ((_ref3 = existingControl[method]) != null) {
          _ref3.apply(existingControl, params);
        }
      } else {
        new iOSCheckbox(checkbox, args[0]);
      }
    }
	_refradio = this.filter(':radio');
    for (_i = 0, _len = _refradio.length; _i < _len; _i++) {
      checkbox = _refradio[_i];
      existingControl = $(checkbox).data(dataName);
      if (existingControl != null) {
        method = args[0], params = 2 <= args.length ? __slice.call(args, 1) : [];
        if ((_ref3 = existingControl[method]) != null) {
          _ref3.apply(existingControl, params);
        }
      } else {
        new iOSCheckbox(checkbox, args[0]);
      }
    }
    return this;
  };

  $.fn.iOSCheckbox = function(options) {
    var opts;

    if (options == null) {
      options = {};
    }
    opts = $.extend({}, options, {
      resizeHandle: false,
      disabledClass: 'iOSCheckDisabled',
      containerClass: 'iOSCheckContainer',
      labelOnClass: 'iOSCheckLabelOn',
      labelOffClass: 'iOSCheckLabelOff',
      handleClass: 'iOSCheckHandle',
      handleCenterClass: 'iOSCheckHandleCenter',
      handleRightClass: 'iOSCheckHandleRight',
      dataName: 'iOSCheckbox'
    });
    return this.iphoneStyle(opts);
  };

}).call(this);
})(jQuery);